/* -*-c++-*- Copyright (C) 2018 Advanced Driver Information Technology.
 *
 * This library is open source and may be redistributed and/or modified under
 * the terms of the OpenSceneGraph Public License (OSGPL) version 0.0 or
 * (at your option) any later version.  The full license is in LICENSE file
 * included with this distribution, and on the openscenegraph.org website.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * OpenSceneGraph Public License for more details.
*/

#ifndef WAYLANDBACKEND_WLWINDOWCONTROLLER
#define WAYLANDBACKEND_WLWINDOWCONTROLLER 1

#include <string>
#include "WLClientContext.hpp"
struct wl_surface;

namespace WaylandBackend
{

class WLShellInterface;

class WLWindowController
{
    public:
    
    WLWindowController(void* wlSurface, WLClientContext *wlClientCtx);
    virtual ~WLWindowController();
    
    int init(unsigned int surfaceId, unsigned int layerId, unsigned int width,
             unsigned int height);
    
    std::string& getShellName();
    
    int Configure(int x, int y, unsigned int width, unsigned int height);
    
    int ConfigureSynchronous(int x, int y, unsigned int width, unsigned int height);
    
    int setVisibility(bool visible);
    
    int setTitle(const char *title);
    
    int setClass(const char *surfClass);
    
    int setAsPopup(void *seat, uint32_t serial, WLWindowController *parent,
                   int32_t x, int32_t y, uint32_t flags);
    
    int setMaximized(const char *outputName);
    
    int setFullScreen(uint32_t method, uint32_t framerate,
                      const char *outputName);
    				  
    int setTransient(WLWindowController *parent, int32_t x,
                            int32_t y, uint32_t flags);
    int setTopLevel();
    
    int resize(void *seat, uint32_t serial, uint32_t edges);
    
    int move(void *seat, uint32_t serial);
    
    void* getWlSurface();
    
    private:
    
    struct wl_surface* _wlSurface;
    WLShellInterface* _wlShellIf;
    void*             _shellSurface;
    unsigned int      _surfaceID;
    WLClientContext*  _wlClientCtx;
    bool              _useSurfId; 
};

}

#endif
